/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.util.Vector;
import jclass.bwt.JCSerializable;
import jclass.chart.ArrayDataInterpretation;
import jclass.chart.ChartDataView;
import jclass.chart.Chartable;
import jclass.chart.DirectChartDataView;
import jclass.chart.GeneralDataInterpretation;

abstract class DataInterpretation
implements JCSerializable {
    ChartDataView view;

    static DataInterpretation getData(ChartDataView chartDataView, Chartable chartable) {
        DataInterpretation dataInterpretation;
        int n = chartable.getDataInterpretation();
        switch (n) {
            case 0: {
                dataInterpretation = new ArrayDataInterpretation(chartDataView);
                break;
            }
            case 1: {
                dataInterpretation = new GeneralDataInterpretation(chartDataView);
                break;
            }
            default: {
                throw new RuntimeException("Unknown Chartable data interpretation");
            }
        }
        dataInterpretation.loadData(chartable);
        return dataInterpretation;
    }

    static DataInterpretation getDirectData(DirectChartDataView directChartDataView, Chartable chartable) {
        DataInterpretation dataInterpretation;
        int n = chartable.getDataInterpretation();
        switch (n) {
            case 0: {
                dataInterpretation = new ArrayDataInterpretation(directChartDataView);
                break;
            }
            case 1: {
                dataInterpretation = new GeneralDataInterpretation(directChartDataView);
                break;
            }
            default: {
                throw new RuntimeException("Unknown Chartable data interpretation");
            }
        }
        dataInterpretation.loadDirectData(chartable);
        return dataInterpretation;
    }

    DataInterpretation(ChartDataView chartDataView) {
        this.view = chartDataView;
    }

    abstract void loadData(Chartable var1);

    abstract void loadDirectData(Chartable var1);

    abstract boolean editPoint(int var1, int var2, double var3);

    abstract void changeValue(int var1, int var2);

    abstract void addValue(int var1, int var2);

    abstract void removeValue(int var1, int var2);

    abstract void changeRow(int var1, int var2);

    abstract void addRow(int var1, int var2);

    abstract void removeRow(int var1, int var2);

    void changeColumn(int n, int n2) {
        int n3 = this.view.dataSource.getNumRows();
        int n4 = 0;
        while (n4 < n3) {
            this.changeValue(n4, n2);
            ++n4;
        }
    }

    void addColumn(int n, int n2) {
        int n3 = this.view.dataSource.getNumRows();
        int n4 = 0;
        while (n4 < n3) {
            this.addValue(n4, n2);
            ++n4;
        }
    }

    void removeColumn(int n, int n2) {
        int n3 = this.view.dataSource.getNumRows();
        int n4 = 0;
        while (n4 < n3) {
            this.removeValue(n4, n2);
            ++n4;
        }
    }

    void changePointLabel(int n, int n2) {
        String[] stringArray = this.view.dataSource.getPointLabels();
        if (n2 == -1) {
            this.view.setPointLabels(stringArray);
            return;
        }
        this.view.pointLabels.setElementAt(n2, stringArray[n2]);
        this.view.setChanged(true);
    }

    abstract void changeSeriesName(int var1, int var2);

    abstract void changeSeriesLabel(int var1, int var2);

    abstract void reset(int var1, int var2);

    double[] getX(int n) {
        return this.view.toDoubleArray(this.getXVector(n));
    }

    double[] getY(int n) {
        return this.view.toDoubleArray(this.getYVector(n));
    }

    abstract Vector getXVector(int var1);

    abstract Vector getYVector(int var1);

    abstract double getX(int var1, int var2);

    abstract double getY(int var1, int var2);
}

